/////////////////////////////////////////////////////////////
//
// pgAdmin 4 - PostgreSQL Tools
//
// Copyright (C) 2013 - 2026, The pgAdmin Development Team
// This software is released under the PostgreSQL Licence
//
//////////////////////////////////////////////////////////////
import getApiInstance from '../api_instance';
import DownloadUtils from '../DownloadUtils';

function convertImageURLtoDataURI(api, image) {
  return new Promise(function(resolve, reject) {
    let href = image.getAttribute('href') || image.getAttributeNS('http://www.w3.org/1999/xlink', 'href');
    api.get(href).then(({data})=>{
      image.setAttribute('href', 'data:image/svg+xml;base64,'+window.btoa(data));
      resolve();
    }).catch(()=>{
      reject(new Error(null));
    });
  });
}

export function downloadSvg(svg, svgName) {
  let svgDiv = document.createElement('div');
  svgDiv.innerHTML = svg;
  svgDiv.style.visibility = 'hidden';
  svgDiv.style.display = 'table';
  svgDiv.style.position = 'absolute';
  let svgElement = svgDiv.firstChild;
  let api = getApiInstance();
  if (!svgElement) { return; }

  let images = svgElement.getElementsByTagName('image');
  let image_promises = [];
  if (images){
    for (let image of images) {
      if ((image.getAttribute('href') && image.getAttribute('href').indexOf('data:') === -1)
      || (image.getAttribute('xlink:href') && image.getAttribute('xlink:href').indexOf('data:') === -1)) {
        image_promises.push(convertImageURLtoDataURI(api, image));
      }
    }
  }

  Promise.all(image_promises).then(function() {
    DownloadUtils.downloadTextData(svgElement.outerHTML, svgName, 'image/svg+xml');
  });
}
